#include "HardwareProfile.h"
#include "crc.h"

#pragma udata crcdata

#pragma code usercode

unsigned int CRC7(BYTE* chr, unsigned long cnt)
{
	int i; 
	unsigned long a;
	unsigned char crc,Data; 

	crc=0; 
	for (a=0; a<cnt; a++) 
	{ 
		Data=chr[a]; 
		for (i=0;i<8;i++)
		{ 
		crc <<= 1; 
		if ((Data & 0x80)^(crc & 0x80)) 
		crc ^=0x09; 
		Data <<= 1; 
		} 
	} 
	crc=(crc<<1)|1; 
	return((unsigned int)crc); 
}

#if(USE_CRC_ON_DATA)

unsigned int CRC16(BYTE* chr, unsigned long cnt)
{	
#if 0

	/*
	 Compute the CRC16 of bytes at chr and cnt bytes in total
	 This routine does not use hardware CRC
	*/

	unsigned int CRCResult;
	unsigned int tmp;
	unsigned long i;

	CRCCON = 0x0F; 		/* Configure the polynomial length (PLEN) */
	CRCXOR = 0x1020; 	/* In CRCXOR, configure for the polynomial x^16 + x^12 + x^5 + 1 */
	CRCWDAT = 0x00; 	/* Clear CRCWDAT*/

	for(i = 0; i< cnt; i+=2)
	{
	tmp=((*chr)<<8)+(*(chr+1));
	CRCDAT=tmp; 				/* Populate the FIFO */
	chr+=2;
	if(CRCCONbits.CRCFUL)
	{
	CRCCONbits.CRCGO = 1; 		/* CRC calculation start */
	}
	while(CRCCONbits.CRCFUL); 	/* Wait for available FIFO register */
	}
	CRCDAT = 0x0000;			/* Do this to shift the last word out of the CRC shift register */
	while (!IFS4bits.CRCIF); 	/* Check for interrupt flag bit */
	IFS4bits.CRCIF = 0;
	while(!CRCCONbits.CRCMPT);	/* Wait for CRC shifter to clear FIFO */
	CRCResult = CRCWDAT; 		/* Output result */
	CRCWDAT = 0;
	return CRCResult;
#else

	/*
	
		 Compute the CRC16 of bytes at chr and cnt bytes in total
		 This routine does not use hardware CRC
	
	*/

	unsigned int i;
	unsigned long a;
	unsigned int crc;
	unsigned int tmp;
	
	crc=0;
	for (a=0; a<(cnt+2); a+=2) 
	{ 
		if(a==cnt)tmp=0; else tmp=((*chr)<<8)+(*(chr+1));
		chr+=2; 
		for(i=0;i<16;i++)
		{ 	
			if(crc & 0x8000)
			{
				crc<<=1;
				if(tmp & 0x8000)
				crc^=0x1020;
				else
				crc^=0x1021;
			} else
			{
				crc<<=1;
				if(tmp & 0x8000)crc|=1;
			}
			tmp<<= 1; 
		} 
	}
	return crc;
#endif
}

#endif
